/**********************************************************************
*	Bastion Products Copyright 1998								*
*	All rights reserved										*
*	This source is freely distributable in an unmodified state.		*
*	Last Modified:	5/20/98									*
*	Author:			Jennifer Weston							*
***********************************************************************/

#ifndef _BLITHE_LIB_H_
#define _BLITHE_LIB_H_

#include <OS.h>

#if _BUILDING_BLITHE 
#define _IMPEXP_BLITHE __declspec(dllexport) 
#else 
#define _IMPEXP_BLITHE __declspec(dllimport) 
#endif

//#pragma export on
/*
**	C Interface
*/
#ifdef __cplusplus
extern "C" {
#endif

/* Blithe initialization */
_IMPEXP_BLITHE status_t blithe_init(void);

/* Check to see if a given language id has an application dictionary */
_IMPEXP_BLITHE int has_application_dictionary(int32 inLangID);

/* Returns the user-configured default language */
_IMPEXP_BLITHE int32 get_default_language(void);

/* Gets an entry */
_IMPEXP_BLITHE char* get_entry(int32 inStringID, int32 inLangID, char* inBuffer, int32 inBuffSize);

/* Gets an entry */
_IMPEXP_BLITHE void* get_blob(uint32 inResType,int32 inResID, int32 inLangID,void* inBuffer,size_t inBuffLength,size_t* outBlobSize);

/* Gets the number of bytes in an entry */
_IMPEXP_BLITHE int32 get_entry_length(int32 inStringID, int32 inLangID);

/* Gets the maximum number of bytes for a language in the application, common, 
   and built-in dictionaries*/
_IMPEXP_BLITHE int32 get_max_length(int32 inLangID);

/* Returns a comma-delimited list of the names of the available
   languages (in the common directory) and returns the number of languages */
_IMPEXP_BLITHE int32 get_language_list(char** outList);

/* Gets a particular language name for language ID d */
_IMPEXP_BLITHE char* language_name(int32 inLangID, char* inBuffer, size_t inBuffSize);

/* Gets the language ID for a language called name */
_IMPEXP_BLITHE int32 language_id(char *inName);

/* Gets the raw bits for making the Blithe bitmap */
_IMPEXP_BLITHE size_t get_raw_bits(void** theBits);

#ifdef __cplusplus
}
#endif

//#pragma export off

#endif
